<?php
/*
=====================================================
 DleMovie (Module for CMS DataLife Engine)
-----------------------------------------------------
 Copyright (c) 2011 Alexander Ahminenko
=====================================================
     
-----------------------------------------------------
 E-Mail, ICQ: a.ahminenko@gmail.com, 681216
=====================================================
*/
if ( ! defined ( 'DATALIFEENGINE' ) ) {
	die( 'Hacking attempt!' );
}
class DleMovieRedtube {
	private $main = false;
	private $config = array( );
	private $authorized = false;
	private $authorization = false;
	
	public function __construct( $main ) {
		$this->main = $main;
		$this->config = $main->config;
		return true;
	}
	public function getVideoById( $id ) {
		$query = $this->main->curlQuery( 'http://api.redtube.com/', array( 'data' => 'redtube.Videos.getVideoById', 'video_id' => $id, 'output' => 'json', 'thumbsize' => 'big' ), 'GET', array( ), array( ), $response );
		if ( empty( $response ) ) return false;
		$row = json_decode( $response, true );
		$video = $this->videoRowParse( $row['video'] );
		if ( $video !== false ) return $video;
		return false;
	}
	public function getVideosByTop( $type ) {
		return false;
	}
	public function getVideosByPlaylist( $id ) {
		return false;
	}
	public function uploadVideo( $file ) {
		return false;
	}
	private function videoRowParse( $row ) {
		if ( ! empty( $row['video_id'] ) and $row['video_id'] > 0 ) {
			$data = array( );
			$data['title'] = trim( $this->convertData( $row['title'] ) );
			$data['descr'] = '';
			$duration = trim( $row['duration'] );
			$counter = substr_count( $duration, ':' );
			if ( $counter == 1 ) {
				list( $min, $sec ) = explode( ':', $duration );
				$duration = $min * 60 + $sec;
			} elseif ( $counter == 2 ) {
				list( $hour, $min, $sec ) = explode( ':', $duration );
				$duration = $hour * 60 * 60 + $min * 60 + $sec;
			} else $duration = 0;
			$data['duration'] = $duration;
			$thumbs = count( $row['thumbs'] );
			if ( $thumbs > 1 ) {
				$num = intval( $thumbs / 2 );
				$data['screen']['url'] = trim( $row['thumbs'][$num]['src'] );
				$data['screen']['width'] = intval( $row['thumbs'][$num]['width'] );
			} else {
				$data['screen']['url'] = trim( $row['thumbs'][0]['src'] );
				$data['screen']['width'] = intval( $row['thumbs'][0]['width'] );
			}
			return $data;
		} else return false;
	}
	private function authorization( ) {
		return false;
	}
	private function convertData( $string ) {
		return iconv( 'UTF-8', 'WINDOWS-1251', $string );
	}
}
$redtube = new DleMovieRedtube( $dlemovie );
?>